<?php
############################################################
# PODCAST GENERATOR
#
# Created by Alberto Betella
# http://podcastgen.sourceforge.net
#
# Modified for ESL by Peter Schmitt http://www.Open-ESL.org
# There were errors that occurred if the hosting company changed 
#  their underlying directory structure and thus made the 
#  value of absoluteurl set at podcastgen installation now invalid.
#  To overcome the errors without mucking about too much with the code
#  we will re-determine absoluteurl each runtime on the fly.
# 
# This is Free Software released under the GNU/GPL License.
############################################################

//// Security code, avoids cross-site scripting (Register Globals ON)
if (isset($_REQUEST['GLOBALS']) OR isset($_REQUEST['absoluteurl']) OR isset($_REQUEST['theme_path'])) { exit; } 

//if config.php doesn't exist, stop
if (!file_exists("config.php")) {
header("HTTP/1.1 301 Moved Permanently");
header("Location: setup/"); // redirect to setup
} 

include("config.php"); 

// to fix bug that occurs if host company changes their directory
//  structure:
// now lets reset absoluteurl  (added by Peter Schmitt)
include("core/set_path.php");

// original: include_once($absoluteurl."core/functions.php"); //LOAD ONCE
// below is ESL modification
include_once("core/functions.php"); //LOAD ONCE

// original: include($absoluteurl."core/language.php");
// below is ESL modification
include("core/language.php");


?>
